<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$create = new Create;
$read = new Read;

// Recebe os dados via POST
$domains = filter_input(INPUT_POST, 'domains', FILTER_DEFAULT); //Obrigatório
$userIds = filter_input(INPUT_POST, 'ids', FILTER_DEFAULT); //Obrigatório
$title = !empty(filter_input(INPUT_POST, 'title', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'title', FILTER_DEFAULT) : NULL; //Não obrigatório
$subtitle = !empty(filter_input(INPUT_POST, 'subtitle', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'subtitle', FILTER_DEFAULT) : NULL; //Não obrigatório
$content = !empty(filter_input(INPUT_POST, 'content', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'content', FILTER_DEFAULT) : NULL; //Não obrigatório
$startDate = Check::Data(filter_input(INPUT_POST, 'start', FILTER_DEFAULT)); //Obrigatório
$endDate = !empty(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) ? Check::Data(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) : NULL; //Não obrigatório
$repeat = filter_input(INPUT_POST, 'repeat', FILTER_DEFAULT); //Obrigatório
$duration = !empty(filter_input(INPUT_POST, 'duration', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'duration', FILTER_DEFAULT) : NULL; //Não obrigatório
$scale = !empty(filter_input(INPUT_POST, 'scale', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'scale', FILTER_DEFAULT) : NULL; //Não obrigatório
//
// Verifica se estão vazios
if (empty($domains) || empty($userIds) || empty($startDate) || (empty($title) && empty($subtitle) && empty($content))):
    $error->setError('Parâmetros inválidos ou vazios', 'Envie todos os parâmetros corretamente para salvar a notificação.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif ($repeat === '1' && (empty($duration) || empty($scale))):
    $error->setError('Parâmetros inválidos ou vazios', 'Para repetir um aviso é necessário informar qual o intervalo de tempo entre uma mensagem e outra.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:

    $NotificationData = ['reg_domains' => $domains, 'reg_users' => $userIds, 'reg_title' => $title, 'reg_subtitle' => $subtitle, 'reg_content' => $content, 'reg_start' => $startDate, 'reg_end' => $endDate, 'reg_repeat' => $repeat, 'reg_duration' => $duration, 'reg_scale' => $scale];
    $create->ExeCreate("ws_notifications_reg", $NotificationData);

    if (!$create->getResult()):
        $error->setError('Erro ao cadastrar registro de notificação', 'Não foi possível salvar o registro de notificação, tente novamente!');
        echo json_encode($error->getError(), JSON_PRETTY_PRINT);
        exit;
    else:
        echo json_encode(['notification_reg' => $create->getResult()], JSON_PRETTY_PRINT);
        exit;
    endif;
endif;