<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

// Recebe os dados via POST
$reg = filter_input(INPUT_POST, 'reg', FILTER_DEFAULT); //Obrigatório
$startDate = filter_input(INPUT_POST, 'start', FILTER_DEFAULT); //Não obrigatório
$endDate = !empty(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'end', FILTER_DEFAULT) : NULL; //Não obrigatório

$read = new Read;
$read->FullRead("SELECT *, IF(notification_status = '0', 'Sim', 'Não') AS notification_status, IF(notification_closed IS NULL, '-', DATE_FORMAT(notification_closed, '%d/%m/%y %Hh%i')) AS notification_closed FROM ws_notifications INNER JOIN ws_users ON notification_user = user_id WHERE notification_reg = :reg","reg={$reg}");

$notifications['notifications'] = $read->getResult();

if (empty($notifications)):
    $error->setError('Não há registros para exibir', 'Até o momento não há avisos cadastrados.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($notifications, JSON_PRETTY_PRINT);
    exit;
endif;