<?php
// Header config
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Configurações (conexão e classes)
require '../_app/Config.inc.php';

// Classes de apoio
$error = new Error;
$api = new Api;

// Captura os parametros via GET
$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

// Realiza a autenticação
$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

// Recebe os dados via POST
$field = filter_input(INPUT_GET, 'field', FILTER_DEFAULT);
$startDate = filter_input(INPUT_GET, 'start', FILTER_DEFAULT);
$endDate = filter_input(INPUT_GET, 'end', FILTER_DEFAULT);

// Verifica se estão vazios
if (empty($field) || empty($startDate) || empty($endDate)):
    // Retorna informações sobre o erro
    $error->setError('Parâmetros inválidos', 'Os parâmetros de busca não são válidos.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    
    // Cria busca dinâmica de acordo com o campo "field"
    switch ($field):
        case 'all':
            $where = 'SUM(views_users) as user_views, SUM(views_views) as view_views, SUM(views_pages) as page_views';
            break;
        
        case 'user':
            $where = 'SUM(views_users) as user_views';
            break;
        
        case 'view':
            $where = 'SUM(views_views) as view_views';
            break;
        
        case 'page':
            $where = 'SUM(views_pages) as page_views';
            break;
        
        default:
            $where = 'SUM(views_users) as user_views, SUM(views_views) as view_views, SUM(views_pages) as page_views';
            break;
    endswitch;
    
    // Realiza a busca no banco
    $read = new Read;
    $read->FullRead("SELECT {$where} FROM ws_siteviews_views WHERE views_date BETWEEN '{$startDate}' AND '{$endDate}'");

    $views['views'] = $read->getResult()[0];
endif;

// Verifica se existe registros e realiza o retorno
if (empty($views)):    
    $error->setError('Não há registros para exibir', 'Até o momento não há visitas no site para a data selecionada, aguarde alguns dias e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($views, JSON_PRETTY_PRINT);
    exit;
endif;