<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$delete = new Delete;
$read = new Read;

// Recebe os dados via POST
$reg = filter_input(INPUT_POST, 'reg', FILTER_DEFAULT);
$del = filter_input(INPUT_POST, 'del', FILTER_DEFAULT);
$uid = !empty(filter_input(INPUT_POST, 'uid', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'uid', FILTER_DEFAULT) : NULL;

// Verifica se estão vazios
if (empty($reg)):
    $error->setError('Número de referencia não encontrado', 'Não foi possível encontrar o número de referencia, atualize a página e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif (empty($del)):
    $error->setError('Parâmentros inválidos', 'O parâmetro identificador não foi encontrado ou é inválido.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:

    $deleteError = false;
    $result = false;

    if ($del !== 'user'):
        $delete->ExeDelete("ws_notifications", "WHERE notification_reg = :reg", "reg={$reg}");
        if (!$delete->getResult()):
            $deleteError = true;
        else:
            $result = true;
        endif;
    else:
        $delete->ExeDelete("ws_notifications", "WHERE notification_reg = :reg AND notification_user = :user", "reg={$reg}&user={$uid}");
        if (!$delete->getResult()):
            $deleteError = true;
        endif;

        $read->ExeRead("ws_notifications", "WHERE notification_reg = :reg", "reg={$reg}");
        if (!$read->getResult()):
            $result = true;
        endif;
    endif;

    if ($deleteError):
        $error->setError('Erro ao deletar aviso', 'Não foi possível deletar uma ou mais avisos.');
        echo json_encode(['error' => $error->getError()], JSON_PRETTY_PRINT);
        exit;
    else:
        $error->setError('Sucesso', 'Avisos deletado com sucesso.');
        echo json_encode(['error' => $error->getError(), 'result' => ['deleteall' => $result]], JSON_PRETTY_PRINT);
        exit;
    endif;
endif;