<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$update = new Update;
$delete = new Delete;
$read = new Read;

// Recebe os dados via POST
$reg = filter_input(INPUT_POST, 'reg', FILTER_DEFAULT);
$del = filter_input(INPUT_POST, 'del', FILTER_DEFAULT);
$domain = filter_input(INPUT_POST, 'domain', FILTER_DEFAULT);

// Verifica se estão vazios
if (empty($reg)):
    $error->setError('Número de referencia não encontrado', 'Não foi possível encontrar o número de referencia, atualize a página e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif (empty($domain) && empty($del)):
    $error->setError('Parâmetros inválidos', 'Um dos parâmetros obrigatórios não foi enviado, atualize a página e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:

    $updateError = false;
    $deleteError = false;

    if (!empty($del) && $del === 'notification'):
        $delete->ExeDelete("ws_notifications_reg", "WHERE reg_id = :reg", "reg={$reg}");
        if (!$delete->getResult()):
            $deleteError = true;
        else:
            $result = ['delete' => true, 'deleteall' => true, 'deletereg' => true];
        endif;
    else:
        $read->ExeRead("ws_notifications_reg", "WHERE reg_id = :reg", "reg={$reg}");
        if ($read->getResult()):

            $expDomains = explode(', ', $read->getResult()[0]['reg_domains']);

            if (count($expDomains) > 1):
                $newDomains = [];
                if (in_array($domain, $expDomains)):
                    foreach ($expDomains as $resultDomain):
                        if ($resultDomain !== $domain):
                            array_push($newDomains, $resultDomain);
                        endif;
                    endforeach;

                    $Dados = ['reg_domains' => implode(', ', $newDomains)];
                    $update->ExeUpdate("ws_notifications_reg", $Dados, "WHERE reg_id = :reg", "reg={$reg}");
                    if (!$update->getResult()):
                        $updateError = true;
                    else:
                        $result = ['delete' => true, 'deleteall' => false, 'deletereg' => false];
                    endif;
                endif;
            else:
                $delete->ExeDelete("ws_notifications_reg", "WHERE reg_id = :reg", "reg={$reg}");
                if (!$delete->getResult()):
                    $deleteError = true;
                else:
                    $result = ['delete' => true, 'deleteall' => true, 'deletereg' => false];
                endif;
            endif;
        endif;
    endif;

    if ($deleteError || $updateError):
        $error->setError('Erro ao deletar registro de aviso', 'Não foi possível deletar o registro de aviso.');
        echo json_encode(['error' => $error->getError()], JSON_PRETTY_PRINT);
        exit;
    else:
        $error->setError('Sucesso', 'Registro de avisos deletado com sucesso.');
        echo json_encode(['error' => $error->getError(), 'result' => $result], JSON_PRETTY_PRINT);
        exit;
    endif;
endif;