<?php
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$read = new Read;
$read->FullRead("SELECT image, ordem FROM ws_gallery_images ORDER BY ordem ASC");

$gallery['gallery'] = $read->getResult();

if (empty($gallery)):
    $error->setError('Não há registros para exibir', 'Até o momento não há imagens cadastradas na área de galeria.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($gallery, JSON_PRETTY_PRINT);
    exit;
endif;