<?php
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

// Recebe os dados via POST
$userId = filter_input(INPUT_GET, 'user', FILTER_VALIDATE_INT);
$startDate = filter_input(INPUT_GET, 'start', FILTER_DEFAULT);
$endDate = filter_input(INPUT_GET, 'end', FILTER_DEFAULT);

// Verifica se estão vazios
if (empty($userId) && (empty($startDate) || empty($endDate))):
    // Retorna informações sobre o erro
    $error->setError('Parâmetros inválidos', 'Os parâmetros de busca não são válidos..');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    // Cria busca dinâmica
    $arrWhere = [];
    (!empty($userId) ? array_push($arrWhere, "log_user = {$userId}") : "");
    ((!empty($startDate) && !empty($endDate)) ? array_push($arrWhere, "log_date BETWEEN '{$startDate}' AND '{$endDate}'") : "");
    $where = implode(' AND ', $arrWhere);

    // Realiza a busca no banco
    $read = new Read;
    $read->FullRead("SELECT log_user as user_id, COUNT(log_user) as user_views FROM ws_logs WHERE {$where} GROUP BY log_user");
    
    // Verifica se existe dados para a pesquisa
    if ($read->getRowCount() >= 1):
        $logs['logs'] = $read->getResult();
    else:
        unset($logs);
    endif;
endif;

if (empty($logs)):
    $error->setError('Não há registros para exibir', 'Até o momento não houve acessos ao painel de controle, aguarde mais alguns dias e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($logs, JSON_PRETTY_PRINT);
    exit;
endif;