<?php
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$read = new Read;
$read->FullRead("SELECT COUNT(*) as acessos FROM ws_siteviews_online WHERE online_endview >= NOW() ORDER BY online_endview DESC");

$online['online'] = $read->getResult()[0];

if (empty($online)):
    $error->setError('Não há registros para exibir', 'Até o momento não há usuários cadastrados na base, cadastre ao menos um e teste novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($online, JSON_PRETTY_PRINT);
    exit;
endif;