<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$create = new Create;
$read = new Read;

// Recebe os dados via POST
$reg = filter_input(INPUT_POST, 'reg', FILTER_DEFAULT); //Obrigatório
$userIds = filter_input(INPUT_POST, 'ids', FILTER_DEFAULT); //Obrigatório
$title = !empty(filter_input(INPUT_POST, 'title', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'title', FILTER_DEFAULT) : NULL; //Não obrigatório
$subtitle = !empty(filter_input(INPUT_POST, 'subtitle', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'subtitle', FILTER_DEFAULT) : NULL; //Não obrigatório
$content = !empty(filter_input(INPUT_POST, 'content', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'content', FILTER_DEFAULT) : NULL; //Não obrigatório
$startDate = Check::Data(filter_input(INPUT_POST, 'start', FILTER_DEFAULT)); //Obrigatório
$endDate = !empty(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) ? Check::Data(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) : NULL; //Não obrigatório
$repeat = filter_input(INPUT_POST, 'repeat', FILTER_DEFAULT); //Obrigatório
$duration = !empty(filter_input(INPUT_POST, 'duration', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'duration', FILTER_DEFAULT) : NULL; //Não obrigatório
$scale = !empty(filter_input(INPUT_POST, 'scale', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'scale', FILTER_DEFAULT) : NULL; //Não obrigatório

// Verifica se estão vazios
if(empty($reg)):
    $error->setError('Número de referencia não encontrado', 'Não foi possível encontrar o número de referencia, atualize a página e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif (empty($startDate) || empty($userIds) || (empty($title) && empty($subtitle) && empty($content))):
    $error->setError('Parâmetros inválidos ou vazios', 'Envie todos os parâmetros corretamente para salvar a notificação.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif ($repeat === '1' && (empty($duration) || empty($scale))):
    $error->setError('Parâmetros inválidos ou vazios', 'Para repetir um aviso é necessário informar qual o intervalo de tempo entre uma mensagem e outra.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    $createError = false;
    if ($userIds === 'all'):
        $read->ExeRead("ws_users", "WHERE user_level <= :level", "level=10");
        foreach ($read->getResult() as $user):
            $NotificationData = ['notification_reg' => $reg, 'notification_user' => $user['user_id'], 'notification_title' => $title, 'notification_subtitle' => $subtitle, 'notification_content' => $content, 'notification_start' => $startDate, 'notification_end' => $endDate, 'notification_repeat' => $repeat, 'notification_duration' => $duration, 'notification_scale' => $scale, 'notification_status' => '1'];
            $create->ExeCreate("ws_notifications", $NotificationData);
            if (!$create->getResult()):
                $createError = true;
            endif;
        endforeach;
    else:
        $expIds = explode(', ', $userIds);
        foreach ($expIds as $id):
            $NotificationData = ['notification_reg' => $reg, 'notification_user' => $id, 'notification_title' => $title, 'notification_subtitle' => $subtitle, 'notification_content' => $content, 'notification_start' => $startDate, 'notification_end' => $endDate, 'notification_repeat' => $repeat, 'notification_duration' => $duration, 'notification_scale' => $scale, 'notification_status' => '1'];
            $create->ExeCreate("ws_notifications", $NotificationData);
            if (!$create->getResult()):
                $createError = true;
            endif;
        endforeach;
    endif;


    if ($createError):
        $error->setError('Erro ao cadastrar notificação', 'Não foi possível salvar uma ou mais notificações.');
        echo json_encode($error->getError(), JSON_PRETTY_PRINT);
        exit;
    else:
        $error->setError('Sucesso', 'Avisos enviados com sucesso.');
        echo json_encode($error->getError(), JSON_PRETTY_PRINT);
        exit;
    endif;
endif;