<?php
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$read = new Read;
$read->FullRead("SELECT config_slides as slides, config_gallery as gallery, config_socialmedias as socialmedias FROM ws_config_id");
//$read->FullRead("SELECT config_slides as slides, config_gallery as gallery, config_socialmedias as socialmedias, config_emails as emails, config_footer as footer, config_version as version FROM ws_config_id");

$config['views'] = $read->getResult()[0];

if (empty($config)):
    $error->setError('Não há registros para exibir', 'Não há dados para serem exibidos, atualize a página e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($config, JSON_PRETTY_PRINT);
    exit;
endif;