<?php
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$read = new Read;
$read->FullRead("SELECT SUM(views_users) as user_views, SUM(views_views) as view_views, SUM(views_pages) as page_views FROM ws_siteviews_views");

$views['views'] = $read->getResult()[0];

if (empty($views)):
    $error->setError('Não há registros para exibir', 'Até o momento não há usuários cadastrados na base, cadastre ao menos um e teste novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($views, JSON_PRETTY_PRINT);
    exit;
endif;