<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

// Recebe os dados via POST
$slideId = filter_input(INPUT_GET, 'slide', FILTER_VALIDATE_INT);
$startDate = filter_input(INPUT_GET, 'start', FILTER_DEFAULT);
$endDate = filter_input(INPUT_GET, 'end', FILTER_DEFAULT);

// Verifica se estão vazios
if (empty($slideId) && (empty($startDate) || empty($endDate))):
    // Retorna informações sobre o erro
    $error->setError('Parâmetros inválidos', 'Os parâmetros de busca não são válidos..');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    // Cria busca dinâmica
    $arrWhere = [];
    (!empty($slideId) ? array_push($arrWhere, "view_slide = {$slideId}") : "");
    ((!empty($startDate) && !empty($endDate)) ? array_push($arrWhere, "view_date BETWEEN '{$startDate}' AND '{$endDate}'") : "");
    $where = implode(' AND ', $arrWhere);

    // Realiza a busca no banco
    $read = new Read;
    $read->FullRead("SELECT view_slide as slide_id, COUNT(view_slide) as slide_views FROM ws_slides_views WHERE {$where} GROUP BY view_slide");

    // Verifica se existe dados para a pesquisa
    if ($read->getRowCount() >= 1):
        $slides['slides'] = $read->getResult();
    else:
        unset($slides);
    endif;
endif;

// Verifica se existe registros e realiza o retorno
if (empty($slides)):
    $error->setError('Não há registros para exibir', 'Até o momento não há banners cadastrados na base, cadastre ao menos um e teste novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($slides, JSON_PRETTY_PRINT);
    exit;
endif;