<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

// Recebe os dados via POST
$socialId = filter_input(INPUT_GET, 'social', FILTER_VALIDATE_INT);
$startDate = filter_input(INPUT_GET, 'start', FILTER_DEFAULT);
$endDate = filter_input(INPUT_GET, 'end', FILTER_DEFAULT);

// Verifica se estão vazios
if (empty($socialId) && (empty($startDate) || empty($endDate))):
    // Retorna informações sobre o erro
    $error->setError('Parâmetros inválidos', 'Os parâmetros de busca não são válidos..');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    // Cria busca dinâmica
    $arrWhere = [];
    (!empty($socialId) ? array_push($arrWhere, "views_socialmedia = {$socialId}") : "");
    ((!empty($startDate) && !empty($endDate)) ? array_push($arrWhere, "views_date BETWEEN '{$startDate}' AND '{$endDate}'") : "");
    $where = implode(' AND ', $arrWhere);

    // Realiza a busca no banco
    $read = new Read;
    $read->FullRead("SELECT views_socialmedia as social_id, COUNT(views_socialmedia) as social_views FROM ws_socialmedias_views WHERE {$where} GROUP BY views_socialmedia");

    // Verifica se existe dados para a pesquisa
    if ($read->getRowCount() >= 1):
        $social['social'] = $read->getResult();
    else:
        unset($social);
    endif;
endif;

// Verifica se existe registros e realiza o retorno
if (empty($social)):
    $error->setError('Não há registros para exibir', 'Até o momento não há redes sociais cadastradas na base, cadastre ao menos uma e teste novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($social, JSON_PRETTY_PRINT);
    exit;
endif;