<?php

header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$update = new Update;
$read = new Read;

// Recebe os dados via POST
$reg = filter_input(INPUT_POST, 'reg', FILTER_DEFAULT); //Obrigatório
$userIds = filter_input(INPUT_POST, 'ids', FILTER_DEFAULT); //Obrigatório
$title = !empty(filter_input(INPUT_POST, 'title', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'title', FILTER_DEFAULT) : NULL; //Não obrigatório
$subtitle = !empty(filter_input(INPUT_POST, 'subtitle', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'subtitle', FILTER_DEFAULT) : NULL; //Não obrigatório
$content = !empty(filter_input(INPUT_POST, 'content', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'content', FILTER_DEFAULT) : NULL; //Não obrigatório
$startDate = Check::Data(filter_input(INPUT_POST, 'start', FILTER_DEFAULT)); //Obrigatório
$endDate = !empty(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) ? Check::Data(filter_input(INPUT_POST, 'end', FILTER_DEFAULT)) : NULL; //Não obrigatório
$repeat = filter_input(INPUT_POST, 'repeat', FILTER_DEFAULT); //Obrigatório
$duration = !empty(filter_input(INPUT_POST, 'duration', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'duration', FILTER_DEFAULT) : NULL; //Não obrigatório
$scale = !empty(filter_input(INPUT_POST, 'scale', FILTER_DEFAULT)) ? filter_input(INPUT_POST, 'scale', FILTER_DEFAULT) : NULL; //Não obrigatório
// Verifica se estão vazios
if (empty($reg)):
    $error->setError('Número de referencia não encontrado', 'Não foi possível encontrar o número de referencia, atualize a página e tente novamente.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif (empty($startDate) || empty($userIds) || (empty($title) && empty($subtitle) && empty($content))):
    $error->setError('Parâmetros inválidos ou vazios', 'Envie todos os parâmetros corretamente para salvar a notificação.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
elseif ($repeat === '1' && (empty($duration) || empty($scale))):
    $error->setError('Parâmetros inválidos ou vazios', 'Para repetir um aviso é necessário informar qual o intervalo de tempo entre uma mensagem e outra.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    $updateError = false;
    $NotificationData = ['notification_title' => $title, 'notification_subtitle' => $subtitle, 'notification_content' => $content, 'notification_start' => $startDate, 'notification_end' => $endDate, 'notification_repeat' => $repeat, 'notification_duration' => $duration, 'notification_scale' => $scale];
    if ($userIds === 'all'):
        $update->ExeUpdate("ws_notifications", $NotificationData, "WHERE notification_reg = :reg", "reg={$reg}");
        if (!$update->getResult()):
            $updateError = true;
        endif;
    else:
        $expIds = explode(', ', $userIds);
        foreach ($expIds as $id):
            $update->ExeUpdate("ws_notifications", $NotificationData, "WHERE notification_reg = :reg AND notification_user = :user", "reg={$reg}&user={$id}");
            if (!$update->getResult()):
                $updateError = true;
            endif;
        endforeach;
    endif;


    if ($updateError):
        $error->setError('Erro ao atualizar notificação', 'Não foi possível atualizar uma ou mais notificações.');
        echo json_encode($error->getError(), JSON_PRETTY_PRINT);
        exit;
    else:
        $error->setError('Sucesso', 'Avisos atualizados com sucesso.');
        echo json_encode($error->getError(), JSON_PRETTY_PRINT);
        exit;
    endif;
endif;