<?php
header('Content-Type: application/json; charset-utf-8');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require '../_app/Config.inc.php';

$error = new Error;
$api = new Api;

$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
$token = filter_input(INPUT_GET, 'token', FILTER_DEFAULT);

$apiComm = $api->authentication($email, $token);

if ($apiComm == false):
    echo json_encode($api->getError(), JSON_PRETTY_PRINT);
    exit;
endif;

$read = new Read;
$read->FullRead("SELECT user_id, user_thumb, user_name, user_lastname, user_document, user_genre as user_gender, user_cell, user_email, user_registration, user_level FROM ws_users");

$users['users'] = $read->getResult();

if (empty($users)):
    $error->setError('Não há registros para exibir', 'Até o momento não há usuários cadastrados.');
    echo json_encode($error->getError(), JSON_PRETTY_PRINT);
    exit;
else:
    echo json_encode($users, JSON_PRETTY_PRINT);
    exit;
endif;